#!/bin/sh

#
# $Id$
# STIG_updater.sh
# 
# Copyright (c)2017, Empowered Networks Inc.
#
# Removes old STIG rules that are no longer required and updates the provided
# Policies and Policy Rules to the newest version.
#
#

# NetMRI Username & Password seperated by a colon
SNMP_USERAUTH="admin:admin123"
# NetMRI IP address
SNMP_IP="192.168.2.1";

#
# Client-side jobs' working directory
#
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )";
NETMRI="$DIR/NetMRI";

SELF="$(basename "$(test -L "$0" && readlink "$0" || echo "$0")")";

# JOBs
DELJOB="$NETMRI/PERL/prune_old_rules.pl";
UPJOB="$NETMRI/PERL/update_DISA_policy_rules.pl";

# Begin jobs
echo "$(date) $SELF: Beginning DISA STIG update.";

# Prune old Policy Rules
$DELJOB -h $SNMP_IP -u $SNMP_USERAUTH
ERRCODE=$?;

if [ $ERRCODE -eq 0 ]; then
	echo "$(date) prune_old_rules.pl run: OKAY";
else
	echo "$(date) prune_old_rules.pl run: ERROR_$ERRCODE";
fi

# Update Policy Rule
$UPJOB -h $SNMP_IP -u $SNMP_USERAUTH 
ERRCODE=$?;

if [ $ERRCODE -eq 0 ]; then
	echo "$(date) update_DISA_policy_rules.pl run: OKAY";
else
	echo "$(date) update_DISA_policy_rules.pl run: ERROR_$ERRCODE";
fi
exit;

